/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm.eui;

import ibm.nways.jdm.common.BadValue;
import ibm.nways.jdm.common.Boolean;
import ibm.nways.jdm.common.SpecialValue;
import ibm.nways.jdm.eui.JDMInput;
import ibm.nways.jdm.eui.StringInputRO;
import java.awt.Insets;
import java.util.Locale;
import java.util.ResourceBundle;

public class BooleanInputRO
extends StringInputRO
implements JDMInput {
    protected static ResourceBundle myResources = null;

    public BooleanInputRO() {
        super(BooleanInputRO.getNLSString("falseLabel"));
    }

    public Object getValue() {
        return new Boolean(super.toString().equals(BooleanInputRO.getNLSString("trueLabel")));
    }

    public String toString() {
        return super.toString();
    }

    public void setValue(Object object) {
        if (object instanceof Boolean) {
            Boolean boolean_ = (Boolean)object;
            if (boolean_.value) {
                super.setValue(BooleanInputRO.getNLSString("trueLabel"));
                return;
            }
            super.setValue(BooleanInputRO.getNLSString("falseLabel"));
            return;
        }
        if (object instanceof SpecialValue) {
            SpecialValue specialValue = (SpecialValue)object;
            super.setValue(specialValue);
        }
    }

    public void setValue(String string) {
        String string2 = string.toLowerCase(Locale.getDefault());
        this.hasErrorValue = false;
        this.ignoreValue = false;
        if (string2.equals("true")) {
            super.setValue(BooleanInputRO.getNLSString("trueLabel"));
            return;
        }
        if (string2.equals("false")) {
            super.setValue(BooleanInputRO.getNLSString("falseLabel"));
            return;
        }
        super.setValue(new BadValue());
    }

    public boolean ignoreValue() {
        return this.ignoreValue;
    }

    public boolean isValidValue() {
        if (this.hasErrorValue) {
            return false;
        }
        return super.toString().equals(BooleanInputRO.getNLSString("trueLabel")) || super.toString().equals(BooleanInputRO.getNLSString("falseLabel"));
    }

    protected static String getNLSString(String string) {
        try {
            if (myResources == null) {
                myResources = ResourceBundle.getBundle("ibm.nways.jdm.eui.BooleanInputResources");
            }
            if (myResources == null) {
                return string;
            }
            return myResources.getString(string);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }
}

